<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Permission;
use App\Models\User;

class RoleController extends Controller
{
    //

    public function allRoles() {

        $allusers = User::with('roles')->get();

    //  return response()->json($allusers);

        return view('admin.user_roles.userrole_all', compact('allusers'));
    }
    // End of method

    public function addRole() {
        return view('admin.user_roles.userrole_add');
    }
    // End of method

    public function storeRole(Request $request) {
        Role::create(['name' => $request->name]);

        $notification = array(
            'name' => 'Role created successfully',
            'alert-type' => 'success');

        return redirect()->route('userrole.all')->with('notification');
    }
    // End of method

    public function editRole($id) {

        $roleData = User::findOrFail($id);
       // $allusers = User::with('roles')->where('id',$id)->get();
        $roles = Role::all();
        $allusers = $roleData->roles->pluck('name')->toArray();
       //return response()->json($allusers);

        return view('admin.user_roles.userrole_edit',compact('roleData','allusers','roles'));
    }
    // End of method

    public function updateRole(Request $request) {

        // $request->validate([
        //     'urole' => 'required|string|exists:roles,name',
        // ]);

        $user = User::findOrFail($request->id);

        // Remove old roles and assign the new one
        $user->syncRoles($request->input('urole', []));

        return redirect()->route('userrole.all')->with('success', 'User role updated successfully');
    }
     // End of method
}
