<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('akibas', function (Blueprint $table) {
            $table->id();
            $table->string('member_id')->nullable();
            $table->integer('paymentmethod_id')->nullable();
            $table->integer('paymenttype_id')->nullable();
            $table->decimal('amount')->nullable();
            $table->date('pdate')->nullable();
            $table->string('risiti')->nullable();
            $table->tinyInteger('status')->default('0')->comment('0=Pending, 1=Approved');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('akibas');
    }
};
