
<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\MemberController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\HisaController;
use App\Http\Controllers\PaymentMethodController;
use App\Http\Controllers\PaymentTypeController;
use App\Http\Controllers\UpdateProfileController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DefaultController;
use App\Http\Controllers\AkibaController;
use App\Http\Controllers\MikopoController;
use App\Http\Controllers\LoanPaymentController;

Route::get('/', function () {
    return view('auth.login');
});

 Route::get('/dashboard', function () {
    if (auth()->user()->role === 1) {
        return redirect()->route('admindashboard');
    } else {
        return redirect()->route('memberdashboard');
    }
})->middleware(['auth', 'verified'])->name('dashboard');

// new route based on user role
Route::middleware(['auth', 'verified'])->group(function() {
    Route::get('/admin/dashboard', [AdminController::class, 'index'])->name('admindashboard');
    Route::get('/member/dashboard', [MemberController::class, 'index'])->name('memberdashboard');
});

Route::controller(UpdateProfileController::class)->group(function () {

    Route::get('/admin/logout', 'destroy')->name('admin.logout');
    Route::get('/admin/profile', 'Profile')->name('admin.profile');
    Route::get('/edit/profile', 'editProfile')->name('edit.profile');
    Route::post('/store/profile', 'storeProfile')->name('store.profile');
    Route::get('/changepassword', 'changePassword')->name('change.password');
    Route::post('/update/password', 'updatePassword')->name('update.password');

});

Route::controller(UserController::class)->group(function () {

    Route::get('/admin/users/all', 'allUsers')->name('users.all');
    Route::get('/admin/users/add', 'addUser')->name('add.user');
    Route::post('/admin/users/store', 'userStore')->name('user.store');
    Route::get('/admin/users/edit/{id}', 'userEdit')->name('user.edit');
    Route::post('/admin/users/update', 'userUpdate')->name('user.update');
    Route::get('/admin/users/delete/{id}', 'userDelete')->name('user.delete');
    Route::get('/admin/users/viewhisa/{id}', 'userHisa')->name('user.hisa');
    Route::get('/admin/users/viewakiba/{id}', 'userAkiba')->name('user.akiba');
});

// Dashboard routes
Route::controller(DashboardController::class)->group(function() {
    Route::get('admin/dashboard', 'adminDashboard')->name('admindashboard');
    Route::get('member/dashboard', 'memberDashboard')->name('memberdashboard');
});

// Hisa routes
Route::controller(HisaController::class)->group(function() {
    Route::post('admin/hisa/payment', 'paymentHisa')->name('hisapayment');
    Route::get('admin/hisa/add', 'addHisa')->name('addhisa');
    Route::get('admin/hisa/pending', 'pendinghisa')->name('pendinghisa');
    Route::get('/admin/hisa/hisa_payment_approval/{id}', 'reviewhisa')->name('review.hisa');
    Route::post('/admin/hisa/hisa_approved', 'approvedhisa')->name('approve.hisa');
    Route::post('/admin/hisa/hisa_rejected','rejected_hisa')->name('reject.hisa');
    Route::get('admin/hisa/view', 'view_hisa')->name('view.hisa');
});

// Akiba routes
Route::controller(AkibaController::class)->group(function() {
    Route::post('admin/akiba/payment', 'paymentAkiba')->name('akibapayment');
    Route::get('admin/akiba/add', 'addAkiba')->name('addakiba');
    Route::get('admin/akiba/pending', 'pendingakiba')->name('pendingakiba');
    Route::get('/admin/akiba/akiba_payment_approval/{id}', 'reviewakiba')->name('review.akiba');
    Route::post('/admin/hisa/akiba_approved', 'approvedakiba')->name('approve.akiba');
    Route::post('/admin/hisa/akiba_rejected','rejected_akiba')->name('reject.akiba');
});

// All payment method routes
Route::controller(PaymentMethodController::class)->group(function() {
    Route::get('admin/paymentmethod/all', 'allPaymentMethod')->name('paymentmethods.all');
    Route::get('admin/paymentmethod/add', 'addPaymentMethod')->name('add.paymentmethod');
    Route::post('admin/paymentmethod/store', 'storePaymentMethod')->name('store.paymentmethod');
    Route::get('admin/paymentmethod/edit/{id}', 'editPaymentMethod')->name('edit.paymentmethod');
    Route::post('admin/paymentmethod/update', 'updatePaymentMethod')->name('update.paymentmethod');
    Route::get('admin/paymentmethod/delete/{id}', 'deletePaymentMethod')->name('delete.paymentmethod');
});

// All payment type routes
Route::controller(PaymentTypeController::class)->group(function() {
    Route::get('admin/paymenttype/all', 'allPaymentType')->name('paymenttype.all');
    Route::get('admin/paymenttype/add', 'addPaymentType')->name('add.paymenttype');
    Route::post('admin/paymenttype/store', 'storePaymentType')->name('store.paymenttype');
    Route::get('admin/paymenttype/edit/{id}', 'editPaymentType')->name('edit.paymenttype');
    Route::post('admin/paymenttype/update', 'updatePaymentType')->name('update.paymenttype');
    Route::get('admin/paymenttype/delete/{id}', 'deletePaymentType')->name('delete.paymenttype');
});

// Default routes
Route::controller(DefaultController::class)->group(function() {
    Route::get('/get-paymentmethod', 'GetPaymentmethod')->name('get-paymentmethod');
    Route::get('/get-paymentmethod/{paymentmethod_id}')->name('get-paymenttypename');
    Route::get('/get-user', 'GetUser')->name('get-user');
});

// All Permissions routes
Route::controller(PermissionController::class)->group(function() {
    Route::get('admin/permission/all', 'allPermission')->name('permission.all');
    Route::get('admin/permission/add', 'addPermission')->name('permission.add');
    Route::post('admin/permission/store', 'createPermission')->name('permission.store');
});

// All Roles routes
Route::controller(RoleController::class)->group(function() {
    Route::get('admin/userroles/all', 'allRoles')->name('userrole.all');
    Route::get('admin/userroles/add', 'addRole')->name('userrole.add');
    Route::post('admin/userroles/store', 'storeRole')->name('userrole.store');
    Route::get('admin/userroles/edit/{id}', 'editRole')->name('edit.role');
    Route::post('admin/userroles/update', 'updateRole')->name('role.update');
});

// Mikopo routes
Route::controller(MikopoController::class)->group(function() {
    Route::get('admin/mikopo/payment', 'paymentMkopo')->name('lipamkopo');
    Route::post('admin/mikopo/paid', 'paidMkopo')->name('mkopopaid');
    Route::post('admin/mikopo/finepayment', 'paymentFine')->name('lipafine');
    Route::get('admin/mikopo/add', 'addMkopo')->name('addmkopo');
    Route::get('admin/mikopo/all', 'allMikopo')->name('allmikopo');
    Route::get('/get-user', 'GetUser')->name('get-user');
    Route::get('/get-loan', 'GetLoanAmount')->name('get-loan');
    Route::get('/get-calculator', 'GetCalculator')->name('get-calculator');
    Route::get('admin/mikopo/pending', 'pendingmkopo')->name('pendingmkopo');
    Route::get('/admin/users/viewmkopo/{id}', 'userMkopo')->name('user.mkopo');
    // Route::get('/admin/hisa/hisa_payment_approval/{id}', 'reviewhisa')->name('review.hisa');
    Route::post('/admin/mikopo/all', 'StoreMkopo')->name('store.mkopo');
    // Route::post('/admin/hisa/hisa_rejected','rejected_hisa')->name('reject.hisa');
    // Route::get('admin/hisa/view', 'view_hisa')->name('view.hisa');
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
